<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Contracts;

/**
 * Interface BytecodeSerializerInterface
 * @package Ghoti\Tools\Lispian\VM\Contracts
 */
interface BytecodeSerializerInterface
{
    /**
     * @param array $serialized
     * @return string
     */
    public function serialize(array $serialized): string;

    /**
     * @param string $bytecode
     * @return array
     */
    public function unserialize(string $bytecode): array;
}
