<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Symbolic;

use Ghoti\Tools\Lispian\Assembly\Contracts\CannotCompileTrait;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;

/**
 * Class Identifier
 * @package Ghoti\Tools\Lispian\Assembly\Node\Symbolic
 */
class Identifier extends AbstractNode
{
    use CannotCompileTrait;

    /**
     * Identifier constructor.
     * @param string $identifier
     */
    public function __construct(string $identifier)
    {
        parent::__construct('T_IDENTIFIER', $identifier);
    }
}
