<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Statement
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Statement extends AbstractNode
{
    /**
     * Statement constructor.
     *
     * @param NodeInterface[] $nodes
     */
    public function __construct(array $nodes)
    {
        parent::__construct('STMT', $nodes);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $code = [OpCode::get(OpCode::SCOPE_INIT)];

        /** @var NodeInterface $node */
        foreach ($this->left as $node) {
            /** @noinspection SlowArrayOperationsInLoopInspection */
            $code = \array_merge($code, $node->compile($helper));
        }

        $code[] = OpCode::get(OpCode::SCOPE_RET);
        return $code;
    }
}
