<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Variable;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class PostIncrement
 * @package Ghoti\Tools\Lispian\Assembly\Node\Statement
 */
class PostIncrement extends AbstractNode
{
    /**
     * PostIncrement constructor.
     *
     * @param string $operator
     * @param NodeInterface $variable
     */
    public function __construct(string $operator, NodeInterface $variable)
    {
        parent::__construct($operator, $variable);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Variable $variable */
        $variable = $this->left;

        return \array_merge($variable->compile($helper), [
            OpCode::get(OpCode::PUSH),
            OpCode::get(OpCode::PUSH),
            OpCode::get(OpCode::MOVA), 1,
            'inc' === $this->operator ? OpCode::get(OpCode::ADD) : OpCode::get(OpCode::SUB),
            OpCode::get(OpCode::PUSH),
            OpCode::get(OpCode::POPSYM),
            $variable->left,
            OpCode::get(OpCode::POP)
        ]);
    }
}
