<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Identifier;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Variable;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Dot
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class Dot extends AbstractNode
{
    /**
     * Dot constructor.
     * @param Variable $variable
     * @param NodeInterface[] $access
     */
    public function __construct(Variable $variable, array $access)
    {
        parent::__construct('.', $variable, $access);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $code = $this->left->compile($helper);

        /** @var Identifier $node */
        foreach ($this->right as $node) {
            if ($node instanceof CallObjectMethod) {
                $helper->spliceNode($code, $node);
            } else {
                $code[] = OpCode::get(OpCode::PUSH);
                $code[] = OpCode::get(OpCode::MOVA);
                $code[] = $node instanceof NodeInterface ? $node->left : $node;
                $code[] = OpCode::get(OpCode::DOT);
            }
        }

        return $code;
    }
}
