<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Literal\ListOfThings;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Identifier;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class CallObjectMethod
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class CallObjectMethod extends AbstractNode
{
    /**
     * CallObjectMethod constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(NodeInterface $left, NodeInterface $right)
    {
        parent::__construct('dotcall', $left, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Identifier $method */
        $method = $this->left;
        /** @var ListOfThings $parameters */
        $parameters = $this->right;
        $parameters = $parameters->left;

        $code = [];
        $numParameters = 0;

        // EAX contains the actual value whose method is to be called
        $code[] = OpCode::get(OpCode::PUSH);

        /** @var AbstractNode $node */
        foreach ($parameters as $node) {
            ++$numParameters;
            $helper->spliceNode($code, $node);
            $code[] = OpCode::get(OpCode::PUSH);
        }

        $code[] = OpCode::get(OpCode::MOVA);
        $code[] = $numParameters;
        $code[] = OpCode::get(OpCode::PUSH);
        $code[] = OpCode::get(OpCode::LOAD);
        $code[] = $helper->getStaticData()->getReference($method->left);
        $code[] = OpCode::get(OpCode::DOTCALL);

        return $code;
    }
}
