<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Unary
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Unary extends AbstractNode
{
    /**
     * Unary constructor.
     *
     * @param string $operator
     * @param NodeInterface $right
     */
    public function __construct(string $operator, NodeInterface $right)
    {
        parent::__construct($operator, null, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        return \array_merge(
            $this->right->compile($helper),
            [OpCode::get(OpCode::NOT)]
        );
    }
}
