# Lispian documentation #

Lispian is a [lisp][wiki-lisp]-like interpreted script language written in PHP.

Its purpose is to provide a simple scripting language within an interpreted 
language (PHP) and give its users the ability to influence released code with
script snippets that interact with PHP-internal variables and possibly modify these.

 * Introduction
   * [Getting started](intro/getting-started.md)
   * [Command line programs](intro/command-line.md)
 * Language reference
   * [Basic syntax](ref/syntax.md)
   * [Operators](ref/operators.md)
   * [Flow control](ref/flow-control.md)
   * Functions
   * Constants
 * Features
   * User-defined functions
   * External and tracked variables
   * [Expression chaining](feature/expression-chaining.md)
 * TODO
   * *Unit testing* - code coverage is at a whopping 0% right now.
   * Parser & Lexer
     * added unary, non-binary not `~`
   * VM
     * string concatenation

[wiki-lisp]: https://en.wikipedia.org/wiki/Lisp_(programming_language) "Lisp (programming language)"
