# Lispian documentation #

## Expression chaining ##

The subject of this chapter should really not be considered a "feature" but a work-around.

Since it was the author's intention to adhere to Lisp's list syntax, yet time was short during
implementation, the compromise of _expression chaining_ was invented. It should be regarded as a
distinction between *Lispian* and its inspiring language, Lisp.

Consider this grammar:

```text
statements: statements statement | statement ;
 
statement: if | print ;

print: "print" ... ;

if : "if" condition follows_block else_block ;

follows_block: statements ;

else_block: #empty
          | statements ;
```

The above very short exerpt of the actual grammar would always produce a shift/reduce conflict in 
the parser, since it could never tell when the "follows-block" actually ends and the "else-block" starts. 

This example illustrates the parser's conflict to resolve to above grammar:

```lisp
(if
    (and $foo $bar)
        # true
        (print "Both foo and bar are true\n")
        (print "we're done here\n")
        
        # false
        (print "Either foo or bar are false\n")
)
```

According to the grammar, the `if` statement is the keyword "if" followed by a mandatory condition, 
statements that are executed when the condition is true and an optional block of statements otherwise.

What looks good on paper will definitely irritate the parser, since there's no distinctive lexical symbol 
(token) that separates one or more mandatory "follows" statements and one or more optional "else" statements.

While the above invalid code sample is human-readable, the lexical scanner and ultimately, the parser
ignore all comments and white-space and have no chance to distinguish the control branches.

In order to eliminate this ambiguity and not force the user to resolve those by using intermediate
functions, the expression chaining operator `,` (0x2c) is used. 

This is how the above _syntactically wrong_ program must be written:

```lisp
(if
    (and $foo $bar)
        # true
        (print "Both foo and bar are true\n"),
        (print "we're done here\n")
        
        # false
        (print "Either foo or bar are false\n")
)
```

The minute difference here is the aforementioned chaining operator that allows the parser to 
distinguish both control branches.
