#!/usr/bin/php
<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
require dirname(__DIR__) . '/vendor/autoload.php';

/** @noinspection AutoloadingIssuesInspection */
class MyClass
{
    public $value = [7331, 1337, 1, 2, 3];

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    public function setValue($value)
    {
        $this->value = $value;
    }
}

try {
    $debug = 0x7f;
    $source = <<<'EOS'
#comment
#   (print "Hello, world.\n")
    (do $class.getValue->().1)
#   (printf "value is '%s'\n" $class.getValue)
#   (do $foo.bar.zoid.2)
#   (- (* 2 4) 1)
#   (let $time (time))
#   (printf "Clock says: %d\n" $time)
#   (if (gt 3 1)
#       (print "It's obviously greater.\n"),
#       (print "And then some...\n")
#   )
#   (printf "It's UNIX-time %d now. That's %s.\n"
#       (time) (date "r")
#   )
#(defun greet ($a $b $c) (print $a "Hello" $c "world.\n" $b))
#(greet 1 2 3)
EOS;

    \Ghoti\Tools\Lispian\VM\OpCode::setDebug((bool) $debug);

    $parser = new \Ghoti\Tools\Lispian\Parser($source);
    $parser->YYDebug($debug & 0x3f);
    $node = $parser->YYParse();
    $var = 'SAB';

    $provider = new \Ghoti\Tools\Lispian\VM\Support\BuiltinsProvider([
        'gds' => new \Ghoti\Tools\Lispian\VM\Symbol\TrackedSymbol($var),
        'class' => new MyClass(),
        'foo' => [
            'bar' => [
                'zoid' => [1, 2, 3],
                'gork' => 'Splort'
            ]
        ]
    ]);
    $runner = new \Ghoti\Tools\Lispian\VM\Runner\NodeRunner($provider);
    $result = $runner->run($node, 0 !== ($debug & 0x40));

    var_dump($result, $var);
} catch(\Throwable $t) {
    printf("%s at %s, line %d: %s\n\n", get_class($t), $t->getFile(), $t->getLine(), $t->getMessage());
    printf("%s\n", $t->getTraceAsString());
}
