<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Compiler;

use Ghoti\Tools\Lispian\VM\Contracts\SymbolInterface;

/**
 * Class SymbolTable
 * @package Ghoti\Tools\Lispian\VM\Compiler
 */
class SymbolTable
{
    /** @var SymbolInterface[] */
    protected $symbols;

    /**
     * SymbolTable constructor.
     */
    public function __construct()
    {
        $this->symbols = [];
    }

    /**
     * @param string $name
     * @return SymbolInterface|null
     */
    public function lookup(string $name)
    {
        return $this->symbols[$name] ?? null;
    }

    /**
     * @param SymbolInterface $symbol
     * @return bool
     */
    public function store(SymbolInterface $symbol): bool
    {
        if (null !== $this->lookup($symbol->getName())) {
            return false;
        }

        $this->symbols[$symbol->getName()] = $symbol;
        return true;
    }
}
