<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Symbolic;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;

/**
 * Class Identifier
 * @package Ghoti\Tools\Lispian\Assembly\Node\Symbolic
 */
class Identifier extends AbstractNode
{
    /**
     * Identifier constructor.
     * @param string $identifier
     */
    public function __construct(string $identifier)
    {
        parent::__construct('T_IDENTIFIER', $identifier);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     * @throws SeriousBugException
     */
    public function compile(ScopeHelper $helper): array
    {
        throw new SeriousBugException(\sprintf('%s cannot be called', __METHOD__));
    }
}
