<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Traversable;

/**
 * Class Expressions
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Expressions extends AbstractNode implements \IteratorAggregate
{
    /**
     * Expressions constructor.
     *
     * @param NodeInterface[] $expressions
     */
    public function __construct(array $expressions = null)
    {
        parent::__construct('exprs', $expressions ?? []);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     * @throws SeriousBugException
     */
    public function compile(ScopeHelper $helper): array
    {
        throw new SeriousBugException(\sprintf('%s cannot be called', __METHOD__));
    }

    /**
     * Retrieve an external iterator
     * @link https://php.net/manual/en/iteratoraggregate.getiterator.php
     * @return Traversable An instance of an object implementing <b>Iterator</b> or
     * <b>Traversable</b>
     * @since 5.0.0
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->left);
    }
}
