<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Helper\JumpReference;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class IfCondition
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class IfCondition extends AbstractNode
{
    /**
     * IfCondition constructor.
     *
     * @param NodeInterface $condition
     * @param NodeInterface $then
     * @param NodeInterface|null $else
     */
    public function __construct(NodeInterface $condition, NodeInterface $then, NodeInterface $else = null)
    {
        parent::__construct('T_IF', $condition, $then, $else);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        $code = $this->left->compile($helper);
        $then = $this->right->compile($helper);
        $else = null !== $this->next ? $this->next->compile($helper) : null;

        $code[] = OpCode::JZ;
        $code[] = $ref1 = new JumpReference();
        \array_splice($code, \count($code), 0, $then);

        if (null === $else) {
            $code[] = $ref1->here();
        } else {
            $code[] = OpCode::JMP;
            $code[] = $ref2 = new JumpReference();
            $code[] = $ref1->here();
            \array_splice($code, \count($code), 0, $else);
            $code[] = $ref2->here();
        }

        return $code;
    }
}
