<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Identifier;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Variable;
use Ghoti\Tools\Lispian\VM\Compiler\ScopeHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Dot
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class Dot extends AbstractNode
{
    /**
     * Dot constructor.
     * @param Variable $variable
     * @param NodeInterface[] $access
     */
    public function __construct(Variable $variable, array $access)
    {
        parent::__construct('.', $variable, $access);
    }

    /**
     * @param ScopeHelper $helper
     * @return array
     */
    public function compile(ScopeHelper $helper): array
    {
        $code = $this->left->compile($helper);

        /** @var Identifier $node */
        foreach ($this->right as $node) {
            $code[] = OpCode::DOT;
            $code[] = $node->left;
        }

        return $code;
    }
}
