#!/usr/bin/php
<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
require dirname(__DIR__) . '/vendor/autoload.php';

// TODO: list access
// TODO: external objects access

try {
    $source = <<<'EOS'
#comment
#   (print "Hello, world.\n")
#   (print $foo.bar.gork "\n")
    (let $gds "YPS")
#   (let $time (time))
#   (printf "Clock says: %d\n" $time)
#   (if (gt 3 1)
#       (print "It's obviously greater.\n"),
#       (print "And then some...\n")
#   )
#   (printf "It's UNIX-time %d now. That's %s.\n"
#       (time) (date "r")
#   )
#(defun greet ($a $b $c) (print $a "Hello" $c "world.\n" $b))
#(greet 1 2 3)
EOS;


    $parser = new \Ghoti\Tools\Lispian\Parser($source);
    $parser->YYDebug(0x1);
    $node = $parser->YYParse();
    $var = 'SAB';

    $provider = new \Ghoti\Tools\Lispian\VM\Support\BuiltinsProvider([
        'gds' => new \Ghoti\Tools\Lispian\VM\Symbol\TrackedSymbol($var),
        'foo' => [
            'bar' => [
                'zoid' => [1, 2, 3],
                'gork' => 'Splort'
            ]
        ]
    ]);
    $runner = new \Ghoti\Tools\Lispian\VM\Runner\NodeRunner($provider);
    $result = $runner->run($node);

    var_dump($result, $var);
} catch(\Throwable $t) {
    printf("%s at %s, line %d: %s\n\n", get_class($t), $t->getFile(), $t->getLine(), $t->getMessage());
    printf("%s\n", $t->getTraceAsString());
}
