<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Support;

use Ghoti\Tools\Lispian\Exception\VM\UnknownSymbolException;
use Ghoti\Tools\Lispian\VM\Contracts\SymbolProviderInterface;

/**
 * Class SymbolProvider
 *
 * @package Ghoti\Tools\Lispian\VM\Support
 */
class SymbolProvider implements SymbolProviderInterface
{
    /** @var array */
    protected $symbols;

    /**
     * SymbolProvider constructor.
     * @param array $symbols
     */
    public function __construct(array $symbols = [])
    {
        $this->setSymbols($symbols);
    }

    /**
     * @param array $symbols
     * @param bool $reset Use first argument as new total state of symbols
     * @return SymbolProvider
     */
    public function setSymbols(array $symbols, bool $reset = false): SymbolProvider
    {
        if ($reset) {
            $this->symbols = $symbols;
        } else {
            foreach ($symbols as $symbol => $value) {
                $this->symbols[$symbol] = $value;
            }
        }

        return $this;
    }

    /**
     * @param string $symbol
     * @return mixed
     * @throws UnknownSymbolException
     */
    public function lookup(string $symbol)
    {
        if (\array_key_exists($symbol, $this->symbols)) {
            return $this->symbols[$symbol];
        }

        throw new UnknownSymbolException(\sprintf('Unknown symbol "%s"', $symbol));
    }
}
