<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM;

/**
 * Class OpCode
 * @package Ghoti\Tools\Lispian\VM
 */
class OpCode
{
    const DUMP              = 'dump';
    const PR0GRAM_INIT      = 'pr0_init';
    const PR0GRAM_END       = 'pr0_end';
    const SCOPE_INIT        = 'stk_init';
    const SCOPE_RET         = 'stk_pop';
    const LOAD              = 'load';
    const PUSH              = 'spush';
    const POP               = 'spop';
    const MOVA              = 'mova';
    const POPVAR            = 'vpop';
    const POPSYM            = 'sympop';

    const JMP               = 'jmp';
    const JZ                = 'jz';
    const JNZ               = 'jnz';
    const CMPEQ             = 'cmp-eq';
    const CMPNE             = 'cmp-ne';
    const CMPLT             = 'cmp-lt';
    const CMPLTE            = 'cmp-lte';
    const CMPGT             = 'cmp-gt';
    const CMPGTE            = 'cmp-gte';

    const NOT               = 'not';
    const CALL              = 'call';
    const INVOKE            = 'invoke';
    const RET               = 'ret';

    const ADD               = 'add';
    const SUB               = 'sub';
    const MUL               = 'mul';
    const DIV               = 'div';
    const POW               = 'pow';
    const SHL               = 'shl';
    const SHR               = 'shr';

    const NOP               = 'nop';
    const LOOKUP            = 'lookup';
    const DOT               = 'dot';
    const DOTCALL           = 'dotcall';
}
