<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian;

use Ghoti\Tools\Lispian\Exception\Parser\UnexpectedTokenException;
use Ghoti\Tools\Lispian\Lexical\Lexer;

/**
 * Class Parser
 * @package Ghoti\Tools\Lispian
 * @method Lexer getLexer()
 */
class Parser extends Parser\Parser
{
    /**
     * Parser constructor.
     * @param string $source
     */
    public function __construct(string $source)
    {
        $lexer = $this->setLexer($this->createLexer($source))->getLexer();
        parent::__construct($lexer);
    }

    /**
     * @param int $flag
     * @param string $message
     * @return Parser
     */
    protected function debugOutput(int $flag, string $message): self
    {
        static $colorCodes = [
            1  => '1;32',
            2  => '1;33',
            4  => '1;34',
            8  => '1;36',
            16 => '1;31'
        ];

        $colorCode = $colorCodes[$flag] ?? '1;41';

        printf("\x1B[1;%sm%s\x1B[0m", $colorCode, $message);
        return $this;
    }

    /**
     * @return int
     */
    public function getSourceColumn(): int
    {
        if (null === $this->getLexer()) {
            return 0;
        }

        return $this->getLexer()->getColumn();
    }

    /**
     * @return int
     */
    public function getSourceLine(): int
    {
        if (null === $this->getLexer()) {
            return 0;
        }

        return $this->getLexer()->getLine();
    }

    /**
     * @param string $source
     * @return Lexer
     */
    protected function createLexer(string $source): Lexer
    {
        return new Lexer($source);
    }

    /**
     * Parsing error
     *
     * @throws UnexpectedTokenException
     */
    protected function _Error()
    {
        if ($this->isErrorFatal()) {
            throw new UnexpectedTokenException($this);
        }
    }

    /**
     * @return bool
     */
    private function isErrorFatal(): bool
    {
        return true;
    }
}
