<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

namespace Test\Ghoti\Tools\Lispian\Unit\Assembly\Node;

use Ghoti\Tools\Lispian\Assembly\Node\Pr0gram;
use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\Parser;
use Ghoti\Tools\Lispian\VM\OpCode;
use PHPUnit\Framework\TestCase;

class Pr0gramTest extends TestCase
{
    public function testIsEmpty()
    {
        $parser = new Parser('# Just a comment here...');
        /** @var Pr0gram $node */
        $node = $parser->YYParse();
        $this->assertTrue($node->isEmpty());
    }

    /**
     * @dataProvider byteCodeProvider
     * @param bool $opcodeDebug
     * @param bool $codeDebug
     * @param string $source
     * @param string $expectedByteCode
     * @throws SeriousBugException
     */
    public function testToByteCode(bool $opcodeDebug, bool $codeDebug, string $source, string $expectedByteCode)
    {
        OpCode::setDebug($opcodeDebug);
        $parser = new Parser($source);
        /** @var Pr0gram $node */
        $node = $parser->YYParse();
        $code = $node->toByteCode($codeDebug);

        $this->assertEquals($expectedByteCode, $code);
    }

    /**
     * @return array
     */
    public function byteCodeProvider(): array
    {
        return [
            [false, false, '(eq $foo 5)', '[20307,16,240,"foo",18,21,5,35,17,19275]'],
            [false, true, '(eq $foo 5)', '[20307,57005,16,240,"foo",18,21,5,35,17,19275,144,144,144,144,144]'],
            [true, true, '(eq $gds "AMA")', '["pr0_init","jmp",8,"AMA","nop","nop","nop","nop","nop","nop","nop","dump","stk_init","lookup","gds","spush","load",3,"cmp-eq","stk_pop","pr0_end","nop","nop","nop"]'],
            [true, false, '(eq $gds "AMA")', '["pr0_init","jmp",1,"AMA","stk_init","lookup","gds","spush","load",3,"cmp-eq","stk_pop","pr0_end"]']
        ];
    }
}
