<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Symbol;

/**
 * Class TrackedSymbol
 * @package Ghoti\Tools\Lispian\VM\Symbol
 */
class TrackedSymbol
{
    /** @var mixed */
    protected $value;

    /**
     * TrackedSymbol constructor.
     * @param $value
     */
    public function __construct(&$value)
    {
        $this->value = &$value;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     * @return TrackedSymbol
     */
    public function setValue($value): TrackedSymbol
    {
        $this->value = $value;
        return $this;
    }
}
