<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM;

use Ghoti\Tools\Lispian\VM\Contracts\BytecodeSerializerInterface;

use function json_decode, json_encode;

/**
 * Class BytecodeSerializer
 * @package Ghoti\Tools\Lispian\VM
 */
class BytecodeSerializer implements BytecodeSerializerInterface
{
    /**
     * @param array $serialized
     * @return string
     */
    public function serialize(array $serialized): string
    {
        return json_encode($serialized);
    }

    /**
     * @param string $bytecode
     * @return array
     */
    public function unserialize(string $bytecode): array
    {
        return json_decode($bytecode, false);
    }
}
