#
# Lispian grammar file
#

%{
use Ghoti\Tools\Lispian\Assembly\Node;
%}

%%

program         : statements { return new Node\Pr0gram($_[1]) }
                ;

statements      : _statements { return new Node\Statement\Statement($_[1] ?? [new Node\Instruction\Nop()]) }
                ;

_statements     : # empty
                | _statements root_statement { @$_[1][] = $_[2]; return $_[1]; }
                ;

root_statement  : function_declaration
                | statement
                ;

statement       : '(' statement_body ')' { return $_[2] }
                | function_call
                ;

statement_body  : unary
                | plurary
                | boolean
                | arithmetic
                | break_statement
                | nil_statement
                | if_condition
                | do_statement
                | for_statement
                | while_statement
                | assignment
                | post_increment
                | pre_increment
                | regular_expr
                ;

unary           : unary_op expression { return new Node\Arithmetic\Unary($_[1], $_[2]) }
                ;

unary_op        : 'not' ;

plurary         : plurary_op expression expression { return new Node\Arithmetic\Plurary($_[1], $_[2], $_[3]) }
                ;

plurary_op      : 'in' | 'is' | 'eq' | 'ne' | 'lt' | 'lte' | 'gt' | 'gte' ;

boolean         : boolean_op expression_list { return new Node\Arithmetic\Boolean($_[1], $_[2]) }
                ;

boolean_op      : 'and' | 'or' ;

arithmetic      : '+' expression expression_list { return new Node\Arithmetic\Addition($_[2], $_[3]) }
                | '-' expression expression_list { return new Node\Arithmetic\Subtraction($_[2], $_[3]) }
                | '*' expression expression expression_list { return new Node\Arithmetic\Multiplication($_[2], $_[3], $_[4]) }
                | '/' expression expression expression_list { return new Node\Arithmetic\Division($_[2], $_[3], $_[4]) }
                | '**' expression expression { return new Node\Arithmetic\Exponentiation($_[2], $_[3]) }
                | '<<' expression expression { return new Node\Arithmetic\Bitwise\Shift(true, $_[2], $_[3]) }
                | '>>' expression expression { return new Node\Arithmetic\Bitwise\Shift(false, $_[2], $_[3]) }
                ;

regular_expr    : '~' expression regex_pattern { return new Node\Arithmetic\Regex($_[2], $_[3]) }
                ;

regex_pattern   : T_REGEX
                ;

post_increment  : T_POST_INCREMENT variable { return new Node\Statement\PostIncrement($_[1], $_[2]) }
                ;

pre_increment   : T_PRE_INCREMENT variable { return new Node\Statement\PreIncrement($_[1], $_[2]) }
                ;

break_statement : T_BREAK { return new Node\FlowControl\BreakStatement() }
                ;

nil_statement   : T_NIL { return new Node\Literal\Nil() }
                ;

if_condition    : T_IF expression expression else_statement
                    { return new Node\Instruction\IfCondition($_[2], $_[3], $_[4]) }
                ;

else_statement  : # empty
                | expression
                ;

do_statement    : T_DO expression_list { return new Node\FlowControl\DoStatement($_[2]) }
                ;

for_statement   : T_FOR for_head expression_list { return new Node\FlowControl\ForStatement($_[2], $_[3]) }
                ;

for_head        : for_head_optional statement for_head_optional { return new Node\FlowControl\ForHead($_[1], $_[2], $_[3]) }
                ;

for_head_optional: '(' ')' { return new Node\Instruction\Nop() }
                | statement
                ;

while_statement : T_WHILE expression expression_list { return new Node\FlowControl\WhileLoop($_[2], $_[3]) }
                ;

assignment      : T_LET variable expression { return new Node\Instruction\Assignment($_[2], $_[3]) }
                ;

expression      : statement
                | literal
                | list
                | constant
                | dotaccess
                ;

expression_list : expressions { return new Node\Statement\Expressions($_[1]) }
                ;

expressions     : # empty
                | expressions expression { @$_[1][] = $_[2]; return $_[1] }
                ;


literal         : T_STRING { return new Node\Literal\AsciiSequence($_[1]) }
                | T_INTEGER { return new Node\Literal\Number($_[1]) }
                | T_NUMBER { return new Node\Literal\Number($_[1]) }
                ;

constant        : T_CONSTANT { return new Node\Symbolic\Constant($_[1]) }
                ;

variable        : T_VARIABLE { return new Node\Symbolic\Variable($_[1]) }
                ;

dotaccess       : variable dotaccess_chain {
                    if (null === $_[2]) {
                        return $_[1];
                    }
                    return new Node\Instruction\Dot($_[1], $_[2])
                }
                ;

dotaccess_chain : # empty
                | dotaccess_chain '.' dotaccess_rhs { @$_[1][] = $_[3]; return $_[1] }
                ;

dotaccess_rhs   : identifier
                | identifier '->' list { return new Node\Instruction\CallObjectMethod($_[1], $_[3]) }
                | T_INTEGER
                ;

identifier      : T_IDENTIFIER { return new Node\Symbolic\Identifier($_[1]) }
                ;

list            : '(' expression_list ')' { return new Node\Literal\ListOfThings($_[2]) }
                ;

function_call   : '(' identifier expression_list ')'
                        { return new Node\Functions\Call($_[2], $_[3]) }
                ;

function_declaration: '(' T_DEFUN identifier parameter_list statements ')'
                        { return new Node\Functions\Definition($_[3], $_[5], $_[4]) }
                ;

parameter_list  : '(' parameters ')' { return $_[2] }
                ;

parameters      : # empty
                | parameters T_VARIABLE { @$_[1][] = $_[2]; return $_[1]; }
                ;

%%
