<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Exception\VM;

use Ghoti\Tools\Lispian\Exception\Exception;
use Throwable;

use const E_CORE_ERROR;
use const E_CORE_WARNING;
use const E_DEPRECATED;
use const E_ERROR;
use const E_NOTICE;
use const E_RECOVERABLE_ERROR;
use const E_STRICT;
use const E_USER_DEPRECATED;
use const E_USER_ERROR;
use const E_USER_NOTICE;
use const E_USER_WARNING;
use const E_WARNING;

use function sprintf;

/**
 * Class PhpErrorException
 * @package Ghoti\Tools\Lispian\Exception\VM
 */
class PhpErrorException extends Exception
{
    /** @var array */
    static protected $errorTranslator = [
        E_NOTICE => 'Notice',
        E_USER_NOTICE => 'User Notice',
        E_CORE_WARNING => 'Core Warning',
        E_WARNING => 'Warning',
        E_USER_WARNING => 'User Warning',
        E_CORE_ERROR => 'Core Error',
        E_ERROR => 'Error',
        E_USER_ERROR => 'User Error',
        E_RECOVERABLE_ERROR => 'Recoverable Error',

        E_STRICT => 'Strict notice',
        E_DEPRECATED => 'Deprecation notice',
        E_USER_DEPRECATED => 'User deprecation notice'
    ];

    /**
     * PhpErrorException constructor.
     *
     * @param $errno
     * @param $errstr
     * @param $errfile
     * @param $errline
     * @param Throwable|null $previous
     */
    public function __construct($errno, $errstr, $errfile, $errline, Throwable $previous = null)
    {
        $message = sprintf('%s in file %s, line %d: %s',
            static::$errorTranslator[$errno] ?? "Unmapped($errno)",
            $errfile, $errline, $errstr);
        parent::__construct($message, 1541488269, $previous);
    }
}
