<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Nil
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Literal
 */
class Nil extends AbstractNode
{
    /**
     * Nil constructor.
     */
    public function __construct()
    {
        parent::__construct('NOP');
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        return [OpCode::get(OpCode::NOP)];
    }
}
