<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Instruction;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Literal\AsciiSequence;
use Ghoti\Tools\Lispian\Assembly\Node\Symbolic\Variable;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Assignment
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Instruction
 */
class Assignment extends AbstractNode
{
    /**
     * Assignment constructor.
     *
     * @param NodeInterface $variable
     * @param NodeInterface $value
     */
    public function __construct(NodeInterface $variable, NodeInterface $value)
    {
        parent::__construct('=', $variable, $value);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Variable $target */
        $target = $this->left;
        $target = $target->left;
        /** @var AbstractNode $value */
        $value = $this->right;

        $code = [];

        if (!$this->isConstantExpression($value)) {
            $helper->spliceNode($code, $value);
        } else {
            $value = $value->left;
            $key = $helper->getStaticData()->getReference($value);
            $code[] = OpCode::get(OpCode::LOAD);
            $code[] = $key;
        }

        $code[] = OpCode::get(OpCode::PUSH);
        $code[] = OpCode::get(OpCode::POPSYM);
        $code[] = $target;

        return $code;
    }

    /**
     * @param AbstractNode $value
     * @return bool
     */
    protected function isConstantExpression(AbstractNode $value): bool
    {
        return $value instanceof AsciiSequence;
    }
}
