<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\FlowControl;

use Ghoti\Tools\Lispian\Assembly\Contracts\CannotCompileTrait;
use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;

/**
 * Class ForHead
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\FlowControl
 */
class ForHead extends AbstractNode
{
    use CannotCompileTrait;

    /**
     * ForHead constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     * @param NodeInterface $next
     */
    public function __construct(NodeInterface $left, NodeInterface $right, NodeInterface $next)
    {
        parent::__construct('forhead', $left, $right, $next);
    }
}
