<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\FlowControl;

use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Exception\VM\InvalidBreakException;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;
use DomainException;

/**
 * Class BreakStatement
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\FlowControl
 */
class BreakStatement extends AbstractNode
{
    /**
     * BreakStatement constructor.
     */
    public function __construct()
    {
        parent::__construct('T_BREAK');
    }

    /**
     * @param CompileHelper $helper
     * @return array
     * @throws InvalidBreakException
     */
    public function compile(CompileHelper $helper): array
    {
        try {
            $reference = $helper->getJumpReference();
        } catch (DomainException $exception) {
            throw new InvalidBreakException('Invalid break', 1561961760, $exception);
        }

        return [
            OpCode::get(OpCode::JMP),
            $reference
        ];
    }
}
