<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

use function count;

/**
 * Class Subtraction
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic
 */
class Subtraction extends AbstractNode
{
    /**
     * Subtraction constructor.
     *
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(NodeInterface $left, NodeInterface $right)
    {
        parent::__construct('-', $left, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var AbstractNode $subtrahends */
        $subtrahends = $this->right;

        $code = $this->left->compile($helper);

        if (!count((array) $subtrahends->left)) {
            $code[] = OpCode::get(OpCode::PUSH);
            $code[] = OpCode::get(OpCode::MOVA);
            $code[] = 0;
            $code[] = OpCode::get(OpCode::SUB);
        } else {
            /** @var AbstractNode $summand */
            foreach ($subtrahends as $summand) {
                $code[] = OpCode::get(OpCode::PUSH);
                $helper->spliceNode($code, $summand);
                $code[] = OpCode::get(OpCode::SUB);
            }
        }

        return $code;
    }
}
