# Lispian documentation #

## Variables ##

### Basics ###

Unlike its inspiring language, *Lispian* variables are represented by 
a dollar sign `$` (0x24) immediately followed by the variable's 
identifier. ***Variable names are case-sensitive.***

Variable names MUST begin with either an underscore or a letter and 
MAY continue to consist of underscores, letters or digits. Anything
validated by the following regular expression can be used as a variable
name: `^[$][a-zA-Z_][a-zA-Z\d_]*$`.

#### Initialization ####

It is imperative that variables are "declared" before use. Any attempt
to access an unknown variable will abort script execution. We air-quote
the word "declared", because there is no variable declaration statement
as such, but there is the `let` operator which is the only statement (in
its entirety) that accepts unknown variables and makes them known to the
current scope.

```lisp
# Aborts execution with 'Unknown symbol "x"'
(+ $x 5)

# Make variable known, initialize it
(let $x 1)
``` 

### Variable scope ###

Variables - or symbols - exist in a scope and are destroyed once that
scope becomes invalid; they do not "bleed" into higher scopes.

**Example: variable in function scope**

```lisp
(defun scopetest () 
    (let $a 5)
)

(scopetest)
(print $a "\n") # -> dies with 'Unknown symbol "a"'
```

In this example, `$a` is only available in the scope of the local
function `scopetest`. It is not available in the calling scope; the
script execution aborts.

**Example variable in higher scope**

```lisp
(let $a 5)
(defun scopetest () 
    (print $a "\n")
)
(scopetest) # -> prints "5"
```

Since `$a` is declared in a higher scope, it is also available in
scopes created afterwards.

**Example: scope precedence**

```lisp
(defun scopetest ()
    (let $a "inside")
    (print $a "\n")
)

(let $a "outside")
(print $a "\n")  # -> outside
(scopetest)      # -> inside
(print $a "\n")  # -> outside
```

Scopes have precedence from inner- to outer-most scope.

### Data types ###

*Lispian* is an untyped language: a variable may be an integer, a string,
an array, a boolean, etc. and may change its type during the course of
execution.

Comparison operators use PHP's identity operators where applicable 
(see [Operators](operators.md)).

While working with basic scalar values is trivial, this chapter will shed
some light on working with arrays or external variables that are objects.

This section assumes, you familiarized yourself with 
[external and tracked variables](../features/external-and-tracked-vars.md).

#### Objects ####

_Describe me._

#### Arrays ####
 
_Describe me._
