# Lispian documentation #

## Opcodes ##

Name              | Literal  | Opcode | Stack | Description
------------------|----------|--------|-------|------------
`DUMP`            | dump     | 0xdead |
`PR0GRAM_INIT`    | pr0_init | 0x4F53 |
`PR0GRAM_END`     | pr0_end  | 0x4b4b |
`SCOPE_INIT`      | stk_init | 0x0010 |
`SCOPE_RET`       | stk_pop  | 0x0011 |
`LOAD`            | load     | 0x000d |
`LOADA`           | loada    | 0x000e |
`POPA`            | apop     | 0x000f |
`PUSH`            | spush    | 0x0012 |
`POP`             | spop     | 0x0014 |
`MOVA`            | mova     | 0x0015 |
`POPVAR`          | vpop     | 0x0016 | (sym)(val) | Look for `sym` in all scopes, set value to `(val)`
`POPSYM`          | sympop   | 0x0017 |
`POPVARL`         | vpopl    | 0x0018 | (sym)(val) | Look for `sym` in current scope, set value to `(val)`
                  |          |        |
`JMP`             | jmp      | 0x0020 |
`JZ`              | jz       | 0x0021 |
`JNZ`             | jnz      | 0x0022 |
`CMPEQ`           | cmp-eq   | 0x0023 |
`CMPNE`           | cmp-ne   | 0x0024 |
`CMPLT`           | cmp-lt   | 0x0025 |
`CMPLTE`          | cmp-lte  | 0x0026 |
`CMPGT`           | cmp-gt   | 0x0027 |
`CMPGTE`          | cmp-gte  | 0x0028 |
`CMPIN`           | cmp-in   | 0x0029 |
                  |          |        |
`NOT`             | not      | 0x0030 |
`CALL`            | call     | 0x0031 |
`INVOKE`          | invoke   | 0x0032 |
`RET`             | ret      | 0x0033 |
                  |          |        |
`ADD`             | add      | 0x0040 |
`SUB`             | sub      | 0x0041 |
`MUL`             | mul      | 0x0042 |
`DIV`             | div      | 0x0043 |
`POW`             | pow      | 0x0044 |
`SHL`             | shl      | 0x0045 |
`SHR`             | shr      | 0x0046 |
                  |          |        |
`MATCH`           | match    | 0x0055 |
                  |          |        |
`NOP`             | nop      | 0x0090 |
`LOOKUP`          | lookup   | 0x00F0 |
`DOT`             | dot      | 0x00F1 |
`DOTCALL`         | dotcall  | 0x00F2 |
