# Lispian documentation #

## Getting started ##

Lispian is available at [Github][github-php-lispian].

### Installing with composer ###

Lispian and its [only dependency][github-php-common] need to be added as repositories in your `composer.json` file:

```
{
    "name": "my/project",
    "repositories": [
        {
            "type": "vcs",
            "url": "git@github.com:Linus-Kleen/php-lispian.git"
        },
        {
            "type": "vcs",
            "url": "git@github.com:Linus-Kleen/php-common.git"
        }
    ],
    "require": [
        "ghoti/php-lispian": "^0.1"
    ]
}
```

### Compiling and running *Lispian* in a nutshell

In order to compile and run *Lispian* scripts, you'll need a parser, a scope provider 
and a byte-code runner instance. This example is the most basic way to execute a script:

```php
use Ghoti\Tools\Lispian\Parser;
use Ghoti\Tools\Lispian\VM\Runner\BytecodeRunner;
use Ghoti\Tools\Lispian\VM\Support\BuiltinsProvider;

// Initialize parser and let it do its thing to create a runnable node
$parser = new Parser('(print "Hello, world.\n")');
$node = $parser->YYParse();

// Convert node to runnable byte-code
$byteCode = $node->toByteCode();

// Initialize a scope provider
$provider = new BuiltinsProvider();

// Run compiled byte-code
$runner = new BytecodeRunner($provider);
$result = $runner->run($byteCode);
```

Refer to the [_external and tracked variables_](../features/external-and-tracked-vars.md)
and [_variables_](../ref/variables.md) chapters of the documentation for more in-depth examples and features.

[github-php-lispian]: https://github.com/Linus-Kleen/php-lispian "Lispian repository"
[github-php-common]: https://github.com/Linus-Kleen/php-common "PHP common code"
