# Lispian documentation #

## Command line programs ##

Lispian provides two command line program as [vendor binaries][composer-vendor-bin].

### Compiler ###

The command line program `lispian-compile.php` compiles Lispian code and outputs the
corresponding byte code into a file.

#### Usage ####

```
php-lispian compiler - Compile Lispian scripts to byte-code


Usage: lispian-compile.php [options...]

Valid options:

  -h [--help]              : Display this help message and abort the program.
  -q [--quiet]             : Do not display any verbosity messages; warnings
                             and errors only.
  -v [--verbose]           : Increase verbosity of progress messages.

  -d [--debug] ARG         : Set debugging level to ARG. (default is "0")

  -f [--file]* ARG         : Read script from file ARG.
  -o [--output] ARG        : Write byte-code to file ARG; if none given, syntax
                             check only.

Parameters marked with * are required.
```

**Debugging parameters**

The `-d` switch requires a numeric argument which is an integer that should be 
constructed by the following bit-fields:

Bit    | Description
-------|---
`0x01` | Token reading (useful for Lexer debugging)
`0x02` | States information
`0x04` | Driver actions (shifts, reduces, accept...)
`0x08` | Parse Stack dump
`0x10` | Error Recovery tracing
`0x40` | Produces padded byte-code with debugging opcodes 

### Script/Byte-code execution ###

The command line program `lispian-run.php` executes pre-compiled byte-code or parses
a script and executes the resulting byte-code.

#### Usage ####


```
php-lispian runner - Run Lispian scripts from byte-code or source


Usage: lispian-run.php [options...]

Valid options:

  -h [--help]              : Display this help message and abort the program.
  -q [--quiet]             : Do not display any verbosity messages; warnings
                             and errors only.
  -v [--verbose]           : Increase verbosity of progress messages.

  -d [--debug] ARG         : Set debugging level to ARG. (default is "0")

  -f [--file]* ARG         : Read byte-code or script from file ARG.
  -t [--type] ARG          : Set source type to ARG. (ARG should be one of
                             "bytecode" or "script"; default is "bytecode")

  -w [--write]             : Write script result to STDERR via var_dump.

Parameters marked with * are required.
```

[composer-vendor-bin]: https://getcomposer.org/doc/articles/vendor-binaries.md "Composer vendor binaries"
