# Lispian documentation #

## Built-in functions ##

The following functions are available in *Lispian* context.

Please note that the table's left column's descriptive format
follows loosely the syntax of [user-defined functions](../ref/functions.md).
In particular, arguments in square brackets are optional. An ellipsis after
an argument's name means "zero or more" arguments.

Lispian function                | PHP equivalent | Description
--------------------------------|----------------|------------
`(date ($format [$stamp]))`     | `date`         | PHP's [`date()`](http://php.net/manual/en/function.date.php) function
`(dump ([$args...]))`           | `var_dump`     | PHP's [`var_dump()`](http://php.net/manual/en/function.var_dump.php) function
`(print ([$args...]))`          | `print`        | PHP's [`print()`](http://php.net/manual/en/function.print.php) function
`(printf ($format [$args...]))` | `printf`       | PHP's [`printf()`](http://php.net/manual/en/function.printf.php) function
`(strftime ($format [$stamp]))` | `strftime`     | PHP's [`strftime()`](http://php.net/manual/en/function.strftime.php) function
`(time)`                        | `time`         | PHP's [`time()`](http://php.net/manual/en/function.time.php) function
