#!/usr/bin/php
<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */

use Ghoti\Tools\Lispian\Parser;
use Ghoti\Tools\Lispian\VM\OpCode;
use Ghoti\Tools\Lispian\VM\Runner\NodeRunner;
use Ghoti\Tools\Lispian\VM\Support\BuiltinsProvider;

require dirname(__DIR__) . '/vendor/autoload.php';

try {
    $debug = 0x40;
    $source = <<<'EOS'
#comment
#   (print "Hello, world.\n")
(if (in ("AA1234" "" 3 "LH1234") "LH1234")
    (print "String found in list\n")
)

(if (in "Parthunax" "x")
    (print "Character found in string\n")
)

#(and (ne $offer.outboundDestinationHub.country "AT") (ne $offer.inboundDestinationHub.country "AT") (ne $offer.outboundDestinationHub.country "BE") (ne $offer.inboundDestinationHub.country "BE") (ne $offer.outboundDestinationHub.country "BG") (ne $offer.inboundDestinationHub.country "BG") (ne $offer.outboundDestinationHub.country "CH") (ne $offer.inboundDestinationHub.country "CH") (ne $offer.outboundDestinationHub.country "CY") (ne $offer.inboundDestinationHub.country "CY") (ne $offer.outboundDestinationHub.country "CZ") (ne $offer.inboundDestinationHub.country "CZ") (ne $offer.outboundDestinationHub.country "DK") (ne $offer.inboundDestinationHub.country "DK") (ne $offer.outboundDestinationHub.country "EE") (ne $offer.inboundDestinationHub.country "EE") (ne $offer.outboundDestinationHub.country "ES") (ne $offer.inboundDestinationHub.country "ES") (ne $offer.outboundDestinationHub.country "FI") (ne $offer.inboundDestinationHub.country "FI") (ne $offer.outboundDestinationHub.country "FR") (ne $offer.inboundDestinationHub.country "FR") (ne $offer.outboundDestinationHub.country "GB") (ne $offer.inboundDestinationHub.country "GB") (ne $offer.outboundDestinationHub.country "GR") (ne $offer.inboundDestinationHub.country "GR") (ne $offer.outboundDestinationHub.country "HR") (ne $offer.inboundDestinationHub.country "HR") (ne $offer.outboundDestinationHub.country "HU") (ne $offer.inboundDestinationHub.country "HU") (ne $offer.outboundDestinationHub.country "IE") (ne $offer.inboundDestinationHub.country "IE") (ne $offer.outboundDestinationHub.country "IS") (ne $offer.inboundDestinationHub.country "IS") (ne $offer.outboundDestinationHub.country "IT") (ne $offer.inboundDestinationHub.country "IT") (ne $offer.outboundDestinationHub.country "LI") (ne $offer.inboundDestinationHub.country "LI") (ne $offer.outboundDestinationHub.country "LT") (ne $offer.inboundDestinationHub.country "LT") (ne $offer.outboundDestinationHub.country "LU") (ne $offer.inboundDestinationHub.country "LU") (ne $offer.outboundDestinationHub.country "LV") (ne $offer.inboundDestinationHub.country "LV") (ne $offer.outboundDestinationHub.country "MT") (ne $offer.inboundDestinationHub.country "MT") (ne $offer.outboundDestinationHub.country "NL") (ne $offer.inboundDestinationHub.country "NL") (ne $offer.outboundDestinationHub.country "NO") (ne $offer.inboundDestinationHub.country "NO") (ne $offer.outboundDestinationHub.country "PL") (ne $offer.inboundDestinationHub.country "PL") (ne $offer.outboundDestinationHub.country "PT") (ne $offer.inboundDestinationHub.country "PT") (ne $offer.outboundDestinationHub.country "RO") (ne $offer.inboundDestinationHub.country "RO") (ne $offer.outboundDestinationHub.country "SE") (ne $offer.inboundDestinationHub.country "SE") (ne $offer.outboundDestinationHub.country "SI") (ne $offer.inboundDestinationHub.country "SI") (ne $offer.outboundDestinationHub.country "SK") (ne $offer.inboundDestinationHub.country "SK"))

#   (for (let $x 0) (lt $x 10) (++ $x)
#       (printf "%d\n" $x)
#       (if (eq $x 5) 
#           (break)))

#    (if (ne 1 1)
#        (do (print "First\n")
#            (print "Second\n"))
#        (print "Third\n"))

# List manipulation
# (let $x "gork")
# (let $a ("one" "two" "three" $x "five" "six"))
# (printf "%s\n" $a.3)

#   (do $class.getValue->().1)
#   (printf "value is '%s'\n" $class.getValue)
#   (do $foo.bar.zoid.2)
#   (- (* 2 4) 1)
#   (let $time (time))
#   (printf "Clock says: %d\n" $time)
#   (if (gt 3 1)
#       (print "It's obviously greater.\n"),
#       (print "And then some...\n")
#   )
#   (printf "It's UNIX-time %d now. That's %s.\n"
#       (time) (date "r")
#   )
#(defun greet ($a $b $c) (print $a "Hello" $c "world.\n" $b))
#(greet 1 2 3)
EOS;

    OpCode::setDebug((bool) $debug);

    $parser = new Parser($source);
    $parser->YYDebug($debug & 0x3f);
    $node = $parser->YYParse();

    $provider = new BuiltinsProvider();
    $runner = new NodeRunner($provider);
    $result = $runner->run($node, 0 !== ($debug & 0x40));

    var_dump($result);
} catch(Throwable $t) {
    printf("%s at %s, line %d: %s\n\n", get_class($t), $t->getFile(), $t->getLine(), $t->getMessage());
    printf("%s\n", $t->getTraceAsString());
}
