<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Symbol;

use Ghoti\Tools\Lispian\VM\Contracts\SymbolInterface;

/**
 * Class AbstractSymbol
 * @package Ghoti\Tools\Lispian\Assembly\Symbol
 */
abstract class AbstractSymbol implements SymbolInterface
{
    /** @var string */
    protected $name;
    /** @var int */
    protected $used;
    /** @var mixed */
    protected $value;

    /**
     * AbstractSymbol constructor.
     * @param string $name
     * @param $value
     */
    public function __construct(string $name, $value = null)
    {
        $this->used = 0;
        $this->name = $name;
        $this->value = $value;
    }

    /**
     * @return bool
     */
    public function isUsed(): bool
    {
        return 0 !== $this->used;
    }

    /**
     * @return AbstractSymbol
     */
    public function reference(): self
    {
        ++$this->used;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $name
     * @return AbstractSymbol
     */
    public function setName(string $name): AbstractSymbol
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @param mixed $value
     * @return AbstractSymbol
     */
    public function setValue($value): AbstractSymbol
    {
        $this->value = $value;
        return $this;
    }
}
