<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Runner;

use Ghoti\Tools\Lispian\Assembly\Node\Pr0gram;
use Ghoti\Tools\Lispian\Exception\VM\RunnerException;
use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;

/**
 * Class NodeRunner
 *
 * @package Ghoti\Tools\Lispian\VM
 */
class NodeRunner extends AbstractRunner
{
    /** @var BytecodeRunner */
    protected $byteCodeRunner;

    /**
     * @param Pr0gram $pr0gram
     * @param bool $debug
     * @return mixed
     * @throws RunnerException
     * @throws SeriousBugException
     */
    public function run(Pr0gram $pr0gram, bool $debug = false)
    {
        return $this->getByteCodeRunner()->run($pr0gram->toByteCode($debug));
    }

    /**
     * @return BytecodeRunner
     */
    public function getByteCodeRunner(): BytecodeRunner
    {
        if (null === $this->byteCodeRunner) {
            $this->byteCodeRunner = new BytecodeRunner($this->symbolProvider);
        }

        return $this->byteCodeRunner;
    }
}
