<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Exception\Lexer;

use Ghoti\Tools\Lispian\Lexical\Lexer;
use Throwable;

use function sprintf, substr;

/**
 * Class UnterminatedRegexException
 * @package Ghoti\Tools\Lispian\Exception\Lexer
 */
class UnterminatedRegexException extends AbstractLexerException
{
    /**
     * UnterminatedRegexException constructor.
     *
     * @param Lexer $lexer
     * @param string $source
     * @param Throwable|null $previousException
     */
    public function __construct(Lexer $lexer, string $source, Throwable $previousException = null)
    {
        $code = 1548081368;
        $message = sprintf('Unterminated regular expression at line %d, column %d: "%s"',
            $lexer->getLine(), $lexer->getColumn(), substr($source, 0, 8));

        parent::__construct($message, $code, $previousException);
    }
}
