<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Statement;

use ArrayIterator;
use Ghoti\Tools\Lispian\Assembly\Contracts\CannotCompileTrait;
use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use IteratorAggregate;
use Traversable;

/**
 * Class Expressions
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode
 */
class Expressions extends AbstractNode implements IteratorAggregate
{
    use CannotCompileTrait;

    /**
     * Expressions constructor.
     *
     * @param NodeInterface[] $expressions
     */
    public function __construct(array $expressions = null)
    {
        parent::__construct('exprs', $expressions ?? []);
    }

    /** @noinspection ReturnTypeCanBeDeclaredInspection */
    /**
     * @return ArrayIterator|Traversable
     */
    public function getIterator()
    {
        return new ArrayIterator($this->left);
    }
}
