<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Literal;

use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class AsciiSequence
 *
 * Why not simply call it "String" you ask? Try for yourself.
 *
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Literal
 */
class AsciiSequence extends AbstractLiteral
{
    /**
     * AsciiSequence constructor.
     * @param string $string
     */
    public function __construct(string $string)
    {
        parent::__construct('string', $string);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $key = $helper->getStaticData()->getReference($this->getConstantValue());
        return [OpCode::get(OpCode::LOAD), $key];
    }

    /**
     * @return string
     */
    public function stringify(): string
    {
        return (string) $this->left;
    }

    /**
     * @return mixed
     */
    public function getConstantValue()
    {
        return $this->left;
    }
}
