<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\FlowControl;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Helper\JumpReference;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Statement\Expressions;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class ForStatement
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\FlowControl
 */
class ForStatement extends AbstractNode
{
    /**
     * ForStatement constructor.
     *
     * @param NodeInterface $head
     * @param NodeInterface $body
     */
    public function __construct(NodeInterface $head, NodeInterface $body)
    {
        parent::__construct('for', $head, $body);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var ForHead $head */
        $head = $this->left;
        /** @var Expressions $body */
        $body = $this->right;

        $loop = new JumpReference();
        $end = new JumpReference();
        $helper->pushJumpReference($end);

        $code = $head->left->compile($helper);
        $code[] = $loop->here();
        $helper->spliceNode($code, $head->right);
        $code[] = OpCode::get(OpCode::JZ);
        $code[] = $end;

        /** @var AbstractNode $node */
        foreach ($body as $node) {
            $helper->spliceNode($code, $node);
        }

        $helper->spliceNode($code, $head->next);
        $code[] = OpCode::get(OpCode::JMP);
        $code[] = $loop;
        $code[] = $end->here();

        $helper->popJumpReference();
        return $code;
    }
}
