<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\FlowControl;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\Assembly\Node\Statement\Expressions;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class DoStatement
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\FlowControl
 */
class DoStatement extends AbstractNode
{
    /**
     * DoStatement constructor.
     *
     * @param NodeInterface $statements
     */
    public function __construct(NodeInterface $statements)
    {
        parent::__construct('T_DO', $statements);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        /** @var Expressions $statements */
        $statements = $this->left;

        $code = [OpCode::get(OpCode::SCOPE_INIT)];

        /** @var NodeInterface $node */
        foreach ($statements as $node) {
            $helper->spliceNode($code, $node);
        }

        $code[] = OpCode::get(OpCode::SCOPE_RET);
        return $code;
    }
}
