<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Helper\JumpReference;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

use function array_shift;
use function count;

/**
 * Class Boolean
 * @package Ghoti\Tools\Lispian\Assembly\AbstractNode\Arithmetic
 */
class Boolean extends AbstractNode
{
    /**
     * Boolean constructor.
     *
     * @param string $operator
     * @param NodeInterface $left
     */
    public function __construct(string $operator, NodeInterface $left)
    {
        parent::__construct($operator, $left);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $opcode = 'and' === $this->operator ? OpCode::get(OpCode::JZ) : OpCode::get(OpCode::JNZ);

        /** @var AbstractNode $expressions */
        $expressions = $this->left;
        /** @var AbstractNode[] $conditions */
        $conditions = $expressions->left;

        $end = new JumpReference();
        $code = [];
        $helper->pushJumpReference($end);

        while (count($conditions)) {
            /** @var NodeInterface $condition */
            $condition = array_shift($conditions);

            $compiled = $condition->compile($helper);
            $helper->spliceCode($code, $compiled);

            /* Last condition needs no jump; EAX is set to its last evaluation */
            if (count($conditions)) {
                $code[] = $opcode;
                $code[] = $end;
            }
        }

        $code[] = $end->here();
        $helper->popJumpReference();
        return $code;
    }
}
