<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2019 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Node\Arithmetic\Bitwise;

use Ghoti\Tools\Lispian\Assembly\Contracts\NodeInterface;
use Ghoti\Tools\Lispian\Assembly\Node\AbstractNode;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;
use Ghoti\Tools\Lispian\VM\OpCode;

/**
 * Class Shift
 *
 * @package Ghoti\Tools\Lispian\Assembly\Node\Arithmetic\Bitwise
 */
class Shift extends AbstractNode
{
    /**
     * Shift constructor.
     *
     * @param bool $isLeftShift
     * @param NodeInterface $left
     * @param NodeInterface $right
     */
    public function __construct(bool $isLeftShift, NodeInterface $left, NodeInterface $right)
    {
        parent::__construct($isLeftShift ? 'shl' : 'shr', $left, $right);
    }

    /**
     * @param CompileHelper $helper
     * @return array
     */
    public function compile(CompileHelper $helper): array
    {
        $code = [];

        $helper->spliceNode($code, $this->right)
            ->spliceCode($code, [OpCode::get(OpCode::PUSH)])
            ->spliceNode($code, $this->left)
            ->spliceCode($code, [OpCode::get('shl' === $this->operator ? OpCode::SHL : OpCode::SHR)]);

        return $code;
    }
}
