<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\Assembly\Contracts;

use Ghoti\Tools\Lispian\Exception\VM\SeriousBugException;
use Ghoti\Tools\Lispian\VM\Compiler\CompileHelper;

use function get_class, sprintf;

/**
 * Trait CannotCompileTrait
 * @package Ghoti\Tools\Lispian\Assembly\Contracts
 */
trait CannotCompileTrait
{
    /**
     * @param CompileHelper $helper
     * @return array
     * @throws SeriousBugException
     */
    public function compile(/** @noinspection PhpUnusedParameterInspection */ CompileHelper $helper): array
    {
        throw new SeriousBugException(sprintf('Cannot compile node "%s" by itself', get_class($this)), 1541326332);
    }
}
