# Lispian documentation #

## Regular expressions ##

### Pattern matching ###

Pattern matching is achieved using the `~` (0x7e) operator (see [Operators][docs-operators]).
This operator returns `true` if the value matches the expression, `false` otherwise.

The pattern matching expression begins with a lower-case `m` (0x6d) immediately followed by
a delimiter character, the actual regular expression and a closing delimiter.

You may use _named_ capture groups. Matches are injected into the current scope as variables 
with the capture group's name (see _Examples_).

**Examples**

```lisp
(let $var "Hello, world.\n")

# Simple match
(if (~ $var m{o}) 
    (print "There is at least one 'o'\n"))

# Capture using a named group
(if (~ $var m{\b(?<word>\w+)\b})
    (printf "The word is '%s'" $word))
    
# Note only named capture groups are converted into result variables
(if (~ $var m{^(\S+)\s(?<rest>.*)$})
    (printf "The rest after the first space is '%s'.\n" $rest))
    
# Count all "o" occurences
(let $count 0)
(while (~ $var m{o})
    (inc $count))
(printf "There are %d 'o's in '%s'.\n" $count $var)
```

### Delimiters ###

The following delimiters are recognized:

Open       | Close
-----------|-----------
`{` (0x7b) | `}` (0x7d)
`(` (0x28) | `)` (0x29)
`~` (0x7e) | _same_
`/` (0x2f) | _same_
`:` (0x3a) | _same_

[docs-operators]: operators.md
