# Lispian documentation #

## Operators ##

### Operator precedence ###

Since *Lispian* uses prefix notation (see [Syntax][docs-syntax]), **there is no operator precedence**.

### Assignment operators ###

Example        | Name       | Result
---------------|------------|-------
`(let $var 5)` | Assignment | Assign variable `$var` the value of `5`; return the value of `$var`.

### Arithmetic operators ###

Example      | Name           | Result
-------------|----------------|-------
`(+ $a $b)`  | Addition       | The sum of `$a` and `$b`
`(- $a $b)`  | Subtraction    | The difference of `$a` and `$b`
`(* $a $b)`  | Multiplication | The product of `$a` and `$b`
`(/ $a $b)`  | Division       | The quotient of `$a` and `$b`
`(** $a $b)` | Exponentiation | The result of `$a` raised to the power of `$b`
`(- $a)`     | Negation       | The opposite of `$a`

### Boolean operators ###

Example       | Name        | Result
--------------|-------------|-------
`(and $a $b)` | Logical and | true, if both `$a` and `$b` are true
`(or $a $b)`  | Logical or  | true, if either both `$a` or `$b` are true
`(not $a)`    | Logical not | true, if  `$a` is not true

As opposed to equally older languages as Lisp (namely Pascal dialects), `or` conditionals
will not be evaluated any further once the first condition is true-ish; `and` conditionals will
not be evaluated any further once the first condition is false-ish.

### Comparison operators ###

Example       | Name                              | Result
--------------|-----------------------------------|-------
`(eq $a $b)`  | Identical                         | true, if both `$a` and `$b` are of the same type and equal*
`(is $a $b)`  | Identical                         | true, if both `$a` and `$b` are of the same type and equal*
`(ne $a $b)`  | Not identical                     | true, if both `$a` and `$b` are of the same type and not equal*
`(gt $a $b)`  | **G**reater **t**han              | true, if `$a` is strictly greater than `$b`
`(gte $a $b)` | **G**reater **t**han or **e**qual | true, if `$a` is strictly greater than or equal to `$b`
`(lt $a $b)`  | **L**ess **t**han                 | true, if `$a` is strictly less than `$b`
`(lte $a $b)` | **L**ess **t**han or **e**qual    | true, if `$a` is strictly less than or equal to `$b`
`(in $a $b)`  | Contains                          | true, if `$a` occurs in list `$b` or if `$a` strictly occurs in string `$b` 

\* Internally, the VM exclusively uses PHP's identity check operators `===` and `!==`, respectively. There
is no operator in *Lispian* that uses implicit type coercion like PHP's `==` (et.al.) operators.

### Bitwise operators ###

***Unimplemented, yet recognized by the lexer.***

Example      | Name                | Result
-------------|---------------------|-------
`(<< $a $b)` | Bitwise left shift  | Shifts `$a` to the left for `$b` bits
`(>> $a $b)` | Bitwise right shift | Shifts `$a` to the right for `$b` bits

### Incremental, decremental operators

Example    | Name           | Result
-----------|----------------|-------
`(inc $a)` | Post-increment | Increments `$a` by one, returns the value of `$a` before incrementation
`(++ $a)`  | Pre-increment  | Increments `$a` by one, returns `$a` afterwards
`(dec $a)` | Post-decrement | Decrements `$a` by one, returns the value of `$a` before decrementation
`(-- $a)`  | Pre-decrement  | Decrements `$a` by one, returns `$a` afterwards

### Other operators ###

Example            | Name                     | Result
-------------------|--------------------------|-------
`(~ $value regex)` | Regular expression match | true, if expression matches (see [Regular expressions][docs-regex]).

### Multiple operator arguments ###

Except where logic prohibits it, it is permitted to provide more than two arguments to any of
the aforementioned arithmetic or boolean operators. The obvious exceptions are unary boolean `not`
and exponentiation `**`:

```lisp
# This:
(+ 1 2 3 4)

# is identical to:
(+ 1 (+ 2 (+ 3 4))

# or:
(+ (+ 1 2) (+ 3 4))
```

Likewise for booleans:

```lisp
# This:
(and $a $b $c $d)

# is identical to:
(and $a (and $b (and $c $d)))

# or:
(and (and $a $b) (and $c $d)) 
```

All variants above would produce the same opcode sequences; it's merely a question of personal
favor which one of the above different identical statements are used.

[docs-syntax]: syntax.md
[docs-regex]: regular-expressions.md
