# Lispian documentation #

## Functions ##

Functions are declared and called using the following syntax:

```lisp
(defun myFunction ($parameter1 $parameter2)
    (print "Example function\n")
    (do $parameter1)
)

(let $retval (myFunction "Foo" "Bar"))
(print $retval "\n") # --> "Foo"
```

Function names follow the same principle as variable names: they MUST
start with a "letter" or underscore and MAY be continued with either 
letters, digits or underscores. They also are case-sensitive.

As of yet, function declarations MUST NOT appear in any scope but the
super-scope (i.e. the "first" scope).

The following script will not compile due to intended restrictions and
fail with an "unexpected token" error:

```lisp
(if (eq 0 0)
    (defun x () (print "Hi\n"))
    (x)
)
```

### Function parameters ###

Function parameters may be empty `()` or a fixed list of required parameters.

Calling a user-defined function with less than its required parameters or more
parameters than required will terminate the script.

```lisp
(defun no_parameters () (print "I require no parameters\n"))

# This is okay:
(no_parameters)

# This will croak:
(no_parameters "Foobar") # -> Dies with 'Too many arguments provided to function "no_parameters": got 1, only need 0'

############################################################

(defun x ($a) (++ $a))

# This is okay:
(x 5)

# This isn't:
(x) # -> Dies with 'Too few arguments provided to function "x": got 0, require 1'
```
