<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Symbol;

/**
 * Class CallableFunction
 * @package Ghoti\Tools\Lispian\Assembly\Symbol
 */
class CallableFunction extends AbstractSymbol
{
    /** @var string[] */
    protected $parameters;

    /**
     * @return string[]
     */
    public function getParameters(): array
    {
        return $this->parameters;
    }

    /**
     * @param string[] $parameters
     * @return CallableFunction
     */
    public function setParameters(array $parameters): CallableFunction
    {
        $this->parameters = $parameters;
        return $this;
    }

    /**
     * @return int
     */
    public function getNumRequiredParameters(): int
    {
        return \count($this->parameters);
    }
}
