<?php
/**
 * @author    Oliver Schieche <lispian@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Lispian\VM\Support;

use Ghoti\Tools\Lispian\VM\Support\Builtins\Functions\BuiltinFunctionsFactory;

/**
 * Class BuiltinsProvider
 * @package Ghoti\Tools\Lispian\VM\Support
 */
class BuiltinsProvider extends SymbolProvider
{
    /**
     * BuiltinsProvider constructor.
     * @param array $symbols
     */
    public function __construct(array $symbols = [])
    {
        parent::__construct($symbols);
        $this->addBuiltIns();
    }

    /**
     * Adds built-in functions to symbol provider
     */
    protected function addBuiltIns()
    {
        BuiltinFunctionsFactory::getInstance()->addToProvider($this);
    }
}
